/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CMutexImpDrvNT.h,v 1.2 1999/09/17 04:20:51 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CMutexImpDrvNT_h	// [
#define Included_CMutexImpDrvNT_h

#include "pgpClassesConfig.h"
#include "CMutexImp.h"

_PGP_BEGIN

// Class CMutexImpDrvNT

class CMutexImpDrvNT : public CMutexImp
{
	friend class CPFLImpFactoryDrvNT;

private:
	CMutexImpDrvNT();

	PGPUInt32	Enter(PGPInt32 msTimeout);
	void		Leave();

private:
	FAST_MUTEX	mFastMutex;		// KMUTEXES suck, don't use them

	mutable PETHREAD	mOwnerThread;
	mutable PGPUInt16	mNumTimesClaimed;
};


// Class CMutexImpDrvNT member functions

inline 
CMutexImpDrvNT::CMutexImpDrvNT() : 
	mOwnerThread(NULL), mNumTimesClaimed(0)
{
	ExInitializeFastMutex(&mFastMutex);
}

inline 
PGPUInt32 
CMutexImpDrvNT::Enter(PGPInt32 msTimeout)
{
	pgpAssert(msTimeout == CMutex::InfiniteTimeout);

	PETHREAD	currentThread	= PsGetCurrentThread();

	if (!ExTryToAcquireFastMutex(&mFastMutex) && 
		(currentThread != mOwnerThread))
	{
		ExAcquireFastMutex(&mFastMutex);
	}

	mNumTimesClaimed++;
	mOwnerThread = currentThread;

	return 0;
}

inline 
void 
CMutexImpDrvNT::Leave()
{
	pgpAssert(mNumTimesClaimed > 0);
	pgpAssert(PsGetCurrentThread() == mOwnerThread);

	if (--mNumTimesClaimed == 0)
	{
		mOwnerThread = NULL;
		ExReleaseFastMutex(&mFastMutex);
	}
}

_PGP_END

#endif	// ] Included_CMutexImpDrvNT_h
